	function [twoc, bits] = INTEGER_2_TWOS_C(i_vec, bits);
 
	% Converts integer numbers to two's-complement representation
	% 
	% i_vec	: a vector of integers
	% bits	: the number of bits (minimum if not specified)
	% 
	% Example INTEGER_2_TWOS_C([13 -13])
	% ans =
	%      0     1     1     0     1
	%      1     0     0     1     1
	
	% 	Toolbox for DIGITAL FILTERS USING MATLAB 
	
	% Author: 			Kenny Johansson 2005-08-24
	% Modified by: 		
	% Copyright:		by authors - not released for commercial use
	% Version:			1 
	% Known bugs: 
	% Report bugs to:	Wanhammar@gmail.com
	
	if ~isnumeric(i_vec)
		error('The input must be in numeric format!');
	end

	if min(size(i_vec)) > 1
		error('The input must be a vector!');
	end

	if any(round(i_vec) ~= i_vec)
		error('This function only works on integers!');
	end

	% Find the required number of bits
	if nargin < 2
		bits = ceil(log2(max(abs(i_vec)))) + 1;
		if any(i_vec == 2^(bits - 1))
			bits = bits + 1;
		end
	end

	% Convert each integer
	twoc = zeros(length(i_vec), bits);
	for i = 1:length(i_vec)
		k = i_vec(i);
		% Compensate for negative numbers
		if k < 0
			k = k + 2^bits;
		end
		% Find the value of all bits
		for b = bits - 1:-1:0
			if k >= 2^b
				twoc(i, bits - b) = 1;
				k = k - 2^b;
			end
		end
	end
